/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : typdefs.h
************************************************************************
* Written by    : Tilmann Wendel, BID R&D, 04.6.96
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, taken out of mini_api.h
************************************************************************
* NOTES :
************************************************************************
*/

/*----------------------------------------------------------------------
 * Performance Board property types definitions added:
 * Robert Siegmund, 10.03.07, BID R&D
 *----------------------------------------------------------------------*/


#ifndef TYPEDEFS_H_INCLUDED
#define TYPEDEFS_H_INCLUDED

#ifdef BEST_FIRMWARE
  do not include this file into firmware
#endif


#include <assert.h>
#include <stdio.h>
#ifdef __KERNEL__
# include <linux/stddef.h>
# include <linux/string.h>
# include <linux/time.h>
#else
# include <stddef.h>
# include <stdlib.h>
# include <string.h>
# include <time.h>
#endif
  
  
/* this file contains basic defines (as type of OS or things like CLI
 * and IMPORT / EXPORT */
#include <defines.h>

#include <berror.h>

/* The following basic typedefs depend on the used machine. We distinguish
 * between HPUX Workstation and Intel based PCs with 16 or 32 Bit technology.

 * Because the Perl script convert.pl reads only lines starting with the
 * keyword CLI, it may read other typedefs than the preprocessor.
 * We dont have to worry about this because the generated Code
 * (dispatch.h) contains only the user defined typedefs, so that the
 * preprocessor can resolve them correctly.
 */

/* ---------------------------------------------------------------
 * General Type Definitions.
 * IMPORTANT; For all data streams or vectors you must use the
 * pointer types below.  This allows correct pointer arithmetic 
 * under DOS/16-bit.
 * --------------------------------------------------------------- */

#if defined(_DOS) && !defined(_WIN32) && !defined(_WIN64) && !defined (DOSW32) /* 16-Bit PCs */
  CLI typedef unsigned char b_int8;
  CLI typedef unsigned int b_int16;
  CLI typedef unsigned long b_int32;
  CLI typedef b_int32 b_int64;
  CLI typedef b_int32 __int64;

  /* pointers to a data stream or array of... */
  CLI typedef b_int8 HUGE * b_int8ptr;
  CLI typedef b_int16 HUGE * b_int16ptr;
  CLI typedef b_int32 HUGE * b_int32ptr;
  CLI typedef b_int64 HUGE * b_int64ptr;

  /* pointers to const.. */
  CLI typedef const b_int8 HUGE * b_cint8ptr;
  CLI typedef const b_int16 HUGE * b_cint16ptr;
  CLI typedef const b_int32 HUGE * b_cint32ptr;
  CLI typedef const b_int64 HUGE * b_cint64ptr;

#else           /* 32-Bit PCs and HPUX */
  typedef unsigned char b_int8;
  typedef unsigned short b_int16;
  typedef unsigned long b_int32;

  #if defined(LINUX)
    #include <stdint.h>
    #define __int64 long long
typedef unsigned long ULONG;
  #elif defined(UNIX) || defined(CCUNIX)
    #define __int64 long
  #endif

  typedef unsigned __int64 b_int64;
  /* pointers to a data stream or array of... */
  typedef b_int8 * b_int8ptr;
  typedef b_int16 * b_int16ptr;
  typedef b_int32 * b_int32ptr;
  typedef b_int64 * b_int64ptr;

  /* pointers to const.. */
  typedef const b_int8 * b_cint8ptr;
  typedef const b_int16 * b_cint16ptr;
  typedef const b_int32 * b_cint32ptr;
  typedef const b_int64 * b_cint64ptr;

#endif


CLI typedef char * b_charptrtype;
CLI typedef const char * b_ccharptrtype;
CLI typedef char ** b_charptrptrtype;

/* constant pointers to.. */
CLI typedef const b_charptrtype b_charcptrtype;
CLI typedef const b_int8ptr b_int8cptr;
CLI typedef const b_int16ptr b_int16cptr;
CLI typedef const b_int32ptr b_int32cptr;
CLI typedef const b_int64ptr b_int64cptr;

CLI typedef int b_bool;
CLI typedef unsigned char b_sizetype;

/* replaced x with a and y with b */
#ifndef __cplusplus
#  ifndef max
#    define max(a,b)    (((a) > (b)) ? (a) : (b))
#  endif
#  ifndef min
#    define min(a,b)    (((a) < (b)) ? (a) : (b))
#  endif
#endif

#define MAXHANDLES    128


/* --------------------------------------------------------------------------
 * B_ERRETURN() is used for ALL returns from exported functions.
 * B_ERRCHECK() is the standard call of an exported CAPI function.
 *
 * NOTE; These macros MUST NOT EVALUATE ErrValOrFuncReturn more than once !!!
 * -------------------------------------------------------------------------- */

#define B_ERRETURN(ErrValOrFuncReturn) \
  return BestLastErrorSet(handle, (ErrValOrFuncReturn))

#define B_ERRCHECK(ErrValOrFuncReturn)  \
  if (B_E_OK != (err = (ErrValOrFuncReturn))) { B_ERRETURN(err); }


/* --------------------------------------------------------------------------
 * B_LICENSECHECK and B_TRY_LICENSE have the same functionality. 
 * B_TRY_LICENSE is more efficient if you use a try block.
 * -------------------------------------------------------------------------- */

#define __HANDLECHECK   ((handle >= 0) &&             \
                         (handle < MAXHANDLES) &&     \
                         handle_array[handle].is_open)

#define HANDLECHECK if (!__HANDLECHECK) { B_ERRETURN (B_E_BAD_HANDLE); }

#define B_LICENSECHECK(item) { HANDLECHECK \
                               B_ERRCHECK(BestCapabilityCheck(handle, (item)))}

#define B_TRY_HANDLE  if (!__HANDLECHECK) B_TRY_ERROR (B_E_BAD_HANDLE)

#define B_TRY_LICENSE(item)  B_TRY_HANDLE \
                             B_TRY (BestCapabilityCheck(handle, (item)));



/* --------------------------------------------------------------------------
 * Function parameter checking macros.
 * NOTE; Every function using one of these macros MUST have its name 
 * declared at the beginning of the function thus;
 *
 * B_DECLARE_FUNCNAME("BestMyFunctionName [cliname]")
 * B_FCT_PARAM_CHK(2, pin_num > 7);
 * // if pin_num (param number 2) really is > 7 then a msg is displayed
 * -------------------------------------------------------------------------- */

#define B_DECLARE_FUNCNAME(funcname) \
    static b_ccharptrtype pFuncName = (funcname)

#define B_FCT_PARAM_MSG(param, reason)                  \
                BestFuncParamMsg(handle, pFuncName, #param, reason)

/* TODO: add value of parameter into makro */

/* Use these normally */

#define B_FCT_PARAM_CHK(param, boolean_test)                \
                if ((boolean_test)) {                               \
                  B_FCT_PARAM_MSG ((param), (#boolean_test));   \
                  B_ERRETURN (B_E_FCT_PARAM);                       \
                }

#define B_FCT_PARAM_CHK_R(param, boolean_test, reason)  \
                if ((boolean_test)) {                           \
                  B_FCT_PARAM_MSG ((param), (reason));          \
                  B_ERRETURN (B_E_FCT_PARAM);                   \
                }

#define B_FCT_PARAM_ERROR(param, reason)                        \
                  B_FCT_PARAM_MSG ((param), (reason));          \
                  B_ERRETURN (B_E_FCT_PARAM)

#define B_FCT_PARAM_NULL_POINTER_CHK(param)             \
                B_FCT_PARAM_CHK_R(param, param == NULL, "null pointer")

#define B_FCT_PARAM_ALIGNMENT_CHK(param, alignment)             \
                {                                                       \
                  char  s2 [32];                                        \
                                                                        \
                  sprintf (s2, "must be %d-aligned", alignment);        \
                  B_FCT_PARAM_CHK_R(param, (param%alignment), s2);      \
                }

#define B_FCT_PARAM_RANGE_CHK(param, lobound, hibound)  \
                B_FCT_PARAM_CHK(param, !(param >= lobound));            \
                B_FCT_PARAM_CHK(param, !(param <= hibound))


/* Use these within try blocks */

#define B_TRY_FCT_PARAM(param, boolean_test)              \
                if ((boolean_test))                               \
                {                                                 \
                  B_FCT_PARAM_MSG ((param), (#boolean_test)); \
                  B_TRY_ERROR (B_E_FCT_PARAM)                     \
                }

#define B_TRY_FCT_PARAM_R(param, boolean_test, reason)  \
                if ((boolean_test)) {                           \
                  B_FCT_PARAM_MSG ((param), (reason));          \
                  B_TRY_ERROR (B_E_FCT_PARAM)                   \
                }

#define B_TRY_FCT_PARAM_X(param, reason)        \
                  B_FCT_PARAM_MSG ((param), (reason));          \
                  B_TRY_ERROR (B_E_FCT_PARAM)

#define B_TRY_FCT_PARAM_NULL_POINTER(param)             \
                B_TRY_FCT_PARAM_R(param, param == NULL, "null pointer")

#define B_TRY_FCT_PARAM_ALIGNMENT(param, alignment)                 \
                {                                                           \
                  char  s3 [32];                                            \
                                                                            \
                  sprintf (s3, "must be %ld-aligned", alignment);           \
                  B_TRY_FCT_PARAM_R(param,(param%alignment), s3);  \
                }

/* TODO: make look similar to property checks */
#define B_TRY_FCT_PARAM_RANGE(param, lobound, hibound)  \
                B_TRY_FCT_PARAM(param, !(param >= lobound));            \
                B_TRY_FCT_PARAM(param, !(param <= hibound))

                                               
/* --------------------------------------------------------------------------
   TRY blocks:

   Try blocks are an efficient way of catching errors in a series of 
   CAPI function calls and are particularly useful for situations where 
   some cleanup is required after an error occurs.  
   In essence this is a type of "goto" mechanism that allows every error 
   condition to follow the same path out of the program.  
   
   Processing within the try block will stop at the first error.
   
   *** All functions in TRY macros must return b_errtype. ***

   How to use (example):

   B_TRY_VARS_NO_PROG;                  # declares all necessary variables

   B_TRY_BEGIN                          # starts a try block
   {
     B_TRY (MyFunction1 (...));         # call functions returning b_errtype
     B_TRY (MyFunction2 (...));

     ... more TRY statements            # other calls can be included

     B_TRY_ERROR (B_E_SOME_ERROR)       # fail with own error code

     B_TRY_FAIL (test ? B_E_OK : B_E_SOME_ERROR); 
                                        # test and fail with own error code 
                                        # block will continue if the error
                                        # expression evaluates to B_E_OK
   }

   B_TRY_CATCH                          # the catch block is optional
   {
     ... free memory, perform common cleanup,
     ... add special error messages etc. here
   }

   B_ERRETURN(B_TRY_RET);               # the reason for the failure
                                        # you can evaluate this makro
                                        # wherever you like.


   ===========================================================================
   For situations where the cleanup depends on which instructions or calls
   were made before the error was encountered there is a "progress" mechanism
   for tracking this.  Here is an example of using progress;

   B_TRY_VARS;

   B_TRY_BEGIN
   {
     ...call a normal CAPI function
     B_TRY (SomeFunction (...));

     ...start something
     B_TRY_PROGRESS ( StartSomething() );

     ... more TRY statements

   }

   B_TRY_CATCH                          # the catch block is NOT optional
   {
     B_TRY_PASSED
     {
        ... we got an error AFTER something was started
        (void) StopSomething();
     }
     B_TRY_FAILED
     {
        ... something was never started...
     }
   }

   B_ERRETURN(B_TRY_RET);

   NOTE; The use of progress tracking makes a function difficult to read
   and maintain and should be limited to cases where it's really necessary.
 * -------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------
 * DO NOT (***NOT***) make ANY of these macros (except for B_TRY_VARS)
 * more than ONE (1) statement.
 * They are used in hundreds of places and are not always enclosed in braces
 * -------------------------------------------------------------------------- */

#ifdef NO_TRY_MACROS  /* this is all Joel's fault... */

#define B_TRY_VARS_NO_PROG    int first_time_here = 0; \
                              b_errtype __status = B_E_OK

#define B_TRY_VARS                B_TRY_VARS_NO_PROG; \
                              int __progress = 0

#define B_TRY_BEGIN           begin_label: if (first_time_here++ == 0) 
#define B_TRY(fct)                if (B_E_OK != (__status = (fct))) goto begin_label
#define B_TRY_PROGRESS(fct)   { B_TRY ((fct)); ++__progress; }
#define B_TRY_FAIL(reason)    B_TRY ((reason))
#define B_TRY_ERROR(errorcode) { __status = (errorcode); goto begin_label;}
#define B_TRY_CATCH               else
#define B_TRY_PASSED            if (__progress-- <= 0 ? 0 : 1)
#define B_TRY_FAILED            else
#define B_TRY_RESET               __progress = 0
#define B_TRY_RET                   __status

#else /* NO_TRY_MACROS */

#include <setjmp.h>

#define B_TRY_VARS_NO_PROG      jmp_buf     __env; \
                              volatile b_errtype __status = B_E_OK; \
                              volatile __btmp

#define B_TRY_VARS                      B_TRY_VARS_NO_PROG; \
                              volatile int __progress = 0

#define B_TRY_BEGIN           __btmp = setjmp(__env); if (__btmp == 0)
#define B_TRY(fct)            if (B_E_OK != (__status = (fct))) longjmp(__env, 1)
#define B_TRY_PROGRESS(fct)       { B_TRY ((fct)); ++__progress; }
#define B_TRY_FAIL(reason)        B_TRY ((reason))
#define B_TRY_ERROR(errorcode)  __status = (errorcode), longjmp(__env, 1);
#define B_TRY_CATCH               else
#define B_TRY_PASSED                  if (__progress-- <= 0 ? 0 : 1)
#define B_TRY_FAILED                  else
#define B_TRY_RESET                     __progress = 0
#define B_TRY_RET             __status

#endif /* NO_TRY_MACROS */


/* ************************************************************************ */



/* The handle represents the number, under which the user can reference his
 * session. There is a struct behind this handle that holds all session
 * related information. */
CLI typedef int b_handletype;

/* We need an Invalid Handle for the Best handle array AND an invalid handle for the OS */
#define INVALID_BEST_HANDLE MAXHANDLES


/* this is the invalid OS handle (used by Windows and cast into b_portnumtype) */
#if (defined(_WIN32) || defined(_WIN64)) && !defined(_DOS)

/* we use the WINDOWS definition for INVALID_HANDLE_VALUE to mark an invalid OS handle */
#define INVALID_OS_HANDLE INVALID_HANDLE_VALUE
typedef void *b_portnumtype;

#else

#define INVALID_OS_HANDLE -1
typedef long int b_portnumtype;

#endif


/* ---------------------------------------------------------------
 * Type Definitions for Session Functions
 * --------------------------------------------------------------- */
enum
{
  B_PORT_COM1 = 1,
  B_PORT_COM2 = 2,
  B_PORT_COM3 = 3,
  B_PORT_COM4 = 4
};

enum
{
  B_PORT_LPT1 = 1,
  B_PORT_LPT2 = 2
};


/* --------------------------------------------------------------------------
 * Timeouts.  For consistency we use the Win32 COMMTIMEOUTS timeout structure.
 * It is very flexible... redefined here to allow use by non-Win32 platforms.
 * Each handle has storage for one timeout structure but this is not used
 * if the device driver has its own storage...(i.e. Kernel-mode drivers).
 * This structure is also declared in timeouts.h for use by device drivers.
 * -------------------------------------------------------------------------- */

#if !BESTTIMEOUTS_DECL
#define BESTTIMEOUTS_DECL 1
typedef struct _BESTTIMEOUTS
{
  b_int32 ReadIntervalTimeout;  /* Maximum time between read chars. */
  b_int32 ReadTotalTimeoutMultiplier; /* Multiplier of characters.        */
  b_int32 ReadTotalTimeoutConstant; /* Constant in milliseconds.        */
  b_int32 WriteTotalTimeoutMultiplier;  /* Multiplier of characters.        */
  b_int32 WriteTotalTimeoutConstant;  /* Constant in milliseconds.        */

} BESTTIMEOUTS, *LPBESTTIMEOUTS;
#endif          /* !BESTTIMEOUTS_DECL */


/* --------------------------------------------------------------------------
 * Hardware options.  The b_hwinfotype structure is part of the "handle"
 * and is filled in during open by BestIdHardware() (static in session.c).
 * It should be considered read-only from that point on!
 * -------------------------------------------------------------------------- */

/* the boardtypes we support ... also used as index into the global lookuptable
 */
typedef enum
{
  B_HW_E2925A = 0,
  B_HW_E2925A_DEEP,
  B_HW_E2926A,
  B_HW_E2926A_DEEP,
  B_HW_E2926B,
  B_HW_E2926B_DEEP,
  B_HW_E2927A,
  B_HW_E2924A,
  B_HW_E2927A_DEEP,
  B_HW_E2928A,
  B_HW_E2928A_DEEP,
  B_HW_E2940A,
  B_HW_E2940A_DEEP,
  B_HW_E2925B,
  B_HW_E2925B_DEEP,
  B_HW_E2921A,
  B_HW_UNKNOWN = 255
} b_hwtype;


/* --------------------------------------------------------------------------
 * The board SERIES ... basically the same as b_hwtype except no _DEEP
 * ------------------------------------------------------------------------- */
typedef enum
{
  B_SERIES_E2925A = 0,
  B_SERIES_E2926A,
  B_SERIES_E2927A,
  B_SERIES_E2928A,
  B_SERIES_E2924A,
  B_SERIES_E2940A,
  B_SERIES_E2925B,
  B_SERIES_UNKNOWN = 255
} b_hwseriestype;


typedef enum
{
  PROTOCOL_1x,                  /* 8-bit */
  PROTOCOL_2x,                  /* 16-bit */
  PROTOCOL_3x,                  /* ?? */
  PROTOCOL_NO                   /* the last one is default for not known */

} b_regfiletype;


/* --------------------------------------------------------------------------
 * Encapsulation of all static hardware info about the currently open board.
 * DO NOT CHANGE THIS STRUCTURE WITHOUT corresponding changes in the
 * initialization array (see BestIdHardware() in session.c).
 * *** DO NOT directly read this structure outside of session.c ***
 * -------------------------------------------------------------------------- */

typedef struct
{
  char *product_string;         /* essential for connecting to a card */
  b_hwtype hw;                  /* compatibility...old handle_array[].hw */
  b_hwseriestype hwseries;      /* hardware series (no deep id) */
  b_regfiletype regfile;        /* compatibility...old handle_array[].regfile */
  b_int32 dev_id;               /* pci device id stored in card's config space */
  b_int32 hwbitmask;            /* access funcs in session.c */
} b_hwinfotype;

#define B_HW_INFO_UNKNOWN {"UNKNOWN", B_HW_UNKNOWN, B_SERIES_UNKNOWN, \
                            PROTOCOL_NO, 0, 0}



CLI                             /* DEF_START ~G_General */
/* ---------------------------------------------------------------
 * General Defines
 * --------------------------------------------------------------- */
#define B_SIZE_BYTE   1         /* @byte  */
#define B_SIZE_WORD   2         /* @word  */
#define B_SIZE_DWORD  4         /* @dword */
CLI                             /* DEF_END */

CLI                             /* DEF_START ~G_Baudrate */
/* ---------------------------------------------------------------
 * Defines for Session Functions
 * --------------------------------------------------------------- */
#define B_BD_2400   2400
#define B_BD_4800   4800
#define B_BD_9600   9600
#define B_BD_19200  19200
#define B_BD_38400  38400
#define B_BD_57600  57600
CLI                             /* DEF_END */


/* ---------------------------------------------------------------
 * Defines for Interrupt Generation Functions
 * --------------------------------------------------------------- */
CLI                             /* DEF_START ~G_G19 */
#define B_INTA             0x1  /* @inta */
#define B_INTB             0x2  /* @intb */
#define B_INTC             0x4  /* @intc */
#define B_INTD             0x8  /* @intd */
CLI                             /* DEF_END */


/* ---------------------------------------------------------------
 * Defines for Miscellaneous Functions
 * --------------------------------------------------------------- */


#include <firmware.h>

/*----------------------------------------------------------------
 * the struct that defines the handle and what the content is
 *----------------------------------------------------------------*/

/* Note: this struct contains all information that belongs to a handle
 * in case this is changed, change also the static initialisation in
 * the file session.c

 * Important; leave "port" as the first element.
 * It is used in all the port switches and thus speed is important.

 * NOTE; the meaning of entered_port is dependent on b_porttype...
 *       and will change if BestDevIdentifierGet() or BestHIFCardIdentifierGet()
 *       is used (i.e. with PCI or HIF).
 */

/* forward declaration */
struct b_dynamic_cap_type;
typedef struct b_dynamic_cap_type b_dynamic_capability_type;

typedef struct
{
  b_porttype port;              /* enum b_porttype ... B_PORT_PCI_CONF etc. */
  b_portnumtype portnumber;     /* OS internal reference number for port
                                 * accesses */
  b_int32 entered_port;         /* symbolic port number as entered
                                 * (B_PORT_COM1 etc. ) */
  b_int8 is_open;
  b_int8 is_connected;
  b_int8 is_reserved;           /* CZ, 13.2.98 */
  b_hwinfotype hwinfo;          /* SCR; 4.12.97 */
  b_int32 param;
  b_int8 regwidth;              /* SCR; currently set datawidth (in # of
                                 * bytes) */
  int regindex;                 /* SCR; index to register values and widths */
  BESTTIMEOUTS timeouts;        /* SCR; 2.12.97 */
  void (*cb_printf) (char *,...); /* these functions are callback */
  void (*cb_p_backup) (char *,...); /* functions that get called    */
  void (*cb_setprompt) (char *);/* in debugging and command line */
  int (*cb_getevent) (void);    /* cases */
  b_dynamic_capability_type *capable; /* hold the dynamic capabilities */
  b_int32 perfboard_gapmode;
  b_lasterrtype lasterr;        /* store information to build good error
                                 * string */
} b_handlestype;


extern b_handlestype handle_array[];


/* the opentask defines what type of open we support */
typedef enum
{
  B_OPEN_STANDARD,
  B_OPEN_STANDARD_RESERVED,
  B_OPEN_FAILSAFE,
  B_OPEN_LICENSE,
  B_OPEN_BIOS_SWITCH,           /* scr; 12/97 */
  B_OPEN_QUICKCHECK,            /* scr; 7/98 */
  B_OPEN_RESERVE
} b_OpenType;


typedef enum
{
  B_CLOSE_STANDARD,
  B_CLOSE_RESERVED
} b_closetype;


/* --------------------------------------------------------------------------
 * Structure to retrieve information about a port
 * -------------------------------------------------------------------------- */

#define SIZEOF_POP_STR  24  /* in bytes */

typedef struct _B_DEVICE_DATA
{
  const char * product_string;      /* "E2926A" etc. */
  char serial_number[21];           /* needed for unique card ID */
  char port_string[SIZEOF_POP_STR]; /* "COM 1", "PCI Bus 0 Slot 7" etc. */
  b_porttype port;                  /* B_PORT_RS232 etc. */
  unsigned long portnum;            /* 0, 1, 0x1234 etc. */
  b_hwinfotype hwinfo;              /* the rest of the story ... be careful! */

} B_DEVICE_DATA;



#endif
